# -*- coding: utf-8 -*-
class Carro:
    '''
    Classe que representa um carro.
    Cada carro possui:
        -cor
        -marca
        -modelo
        -ano
        -km_rodados
        -statusMotor
        -statusMovimento
    '''

    cor = 'sem cor'
    marca = 'sem marca'
    modelo = 'sem modelo'
    ano = 2010
    km_rodados = 0
    statusMotor = True
    statusMovimento = True


    def detalhes(self):
        ''' Exibe os valores de cara atributo do carro '''

        print 'cor:', self.cor
        print 'marca:', self.marca
        print 'modelo:', self.modelo
        print 'ano:', self.ano
        print 'km rodados:', self.km_rodados

    def status(self):
        ''' Exibe na tela o status do motor e movimento do carro
        Implementado usando o operador ternário '''

        print 'O carro está andando' if self.statusMovimento == True else 'O carro está parado'
        print 'O motor está ligado' if self.statusMotor == True else 'O motor está desligado'

    def ligarMotor(self):
        '''Método que liga o motor do carro
        Verifica se está desligado.
        Se estiver, liga. Senão, avisa que o motor já está ligado.'''

        if(self.statusMotor == True):
            print 'O carro já está ligado!'
        else:
            self.statusMotor = True
            print 'Motor ligado!'

    def desligarMotor(self):
        '''Método que desliga o motor
        Verifica se o carro está desligado e parado!'''

        if(self.statusMotor == False):
            print 'O carro já está desligado!'
        else:
            self.statusMotor = False
            self.statusMovimento = False
            print 'Motor desligado!'

    def andar(self):
        '''Método que coloca o carro em movimento
        Verifica antes se o carro está ligado ou desligado'''

        if(self.statusMotor == True):
            if(self.statusMovimento == True):
                print 'O carro já está em movimento!'
            else:
                self.statusMovimento = True
                print 'Carro em movimento!'
        else:
            print 'Para andar é necessário que o carro esteja com o motor ligado'

    def parar(self):
        '''Método que para o carro
        Verifica antes se o carro está com o motor ligado'''

        if(self.statusMotor == True):
            if(self.statusMovimento == True):
                print 'Carro parado'
                self.statusMovimento = False
                self.statusMotor = False
            else:
                print 'Carro já está parado!'
        else:
            print 'O carro já está parado e com motor desligado!'
