# -*- coding: utf-8 -*-
class Pessoa:
    '''
        Exemplo de uso de herança com a classe Pessoa e Pai;

        Classe Pessoa
        Atributos:
            -nome
            -__cpf
            -__endereco
        Métodos:
            -resumo
            -getCPF
            -setCPF

        Classe Pai
        Atributos:
            -filhos
            -esposa
        Métodos:
            -resumo
            -addFilho
            -addEsposa
    '''
    def __init__(self, nome, cpf, endereco):
        self.nome = nome
        self.__cpf = cpf
        self.__endereco = endereco

    def resumo(self):
        print 'Nome: ' + self.nome
        print 'CPF: ' + self.__cpf
        print 'Endereco: ' + self.__endereco

    def getCPF(self):
        return self.__cpf

    def setCPF(self, novoCPF):
        self.__cpf = novoCPF

class Pai(Pessoa):
    def __init__(self, nome, cpf, endereco):
        Pessoa.__init__(self, nome, cpf, endereco)
        self.filhos = []
        self.esposa = None

    def resumo(self):
        Pessoa.resumo(self)
        print "Esposa:" + self.esposa
        print "Filhos:"
        for x in self.filhos:
            print x.nome

    def addFilho(self, filho):
        self.filhos.append(filho)

    def addEsposa(self, esposa):
        self.esposa = esposa
