# -*- coding: utf-8 -*-

class Pessoa(object):

    def __init__(self, nome, tipo, endereco):
        self.nome = nome
        self.tipo = tipo
        self.endereco = endereco

    def resumo(self):
        print 'Nome: ' + self.nome
        print 'Tipo: ' + self.tipo
        print 'Endereco: ' + self.endereco

class Fisica(Pessoa):

    def __init__(self, nome, cpf, endereco):
        Pessoa.__init__(self, nome, 'fisica', endereco)
        self.nome = 'Pessoa Física'
        self.__cpf = cpf

    def getCPF(self):
        return self.__cpf

    @property
    def cpf(self):
        return self.__cpf

    @cpf.setter
    def cpf(self, valor):
        self.__cpf = valor

    def resumo(self):
        Pessoa.resumo(self)
        print 'CPF: ' + self.getCPF()


class Juridica(Pessoa):

    def __init__(self, nome, cnpj, endereco):
        Pessoa.__init__(self, nome, 'juridica', endereco)
        self.nome = 'Pessoa Física'
        self.__cnpj = cnpj

    def getCNPJ(self):
        return self.__cnpj

    def resumo(self):
        Pessoa.resumo(self)
        print 'CNPJ: ' + self.getCNPJ()
