# -*- coding: utf-8 -*-

class Pessoa(object):

    def __init__(self, nome, idade, endereco, cpf, sexo):
        self.nome = nome
        self.idade = idade
        self.endereco = endereco
        self.__cpf = cpf
        self.sexo = sexo

    def resumo(self):
        print 'Nome: ' + self.nome
        print 'Idade: ' + str(self.idade)
        print 'CPF:' + str(self.__cpf)
        print 'Endereco: ' + self.endereco
        print 'Sexo: ' + self.sexo

class Pai(Pessoa):

    def __init__(self, nome, idade, endereco, cpf, sexo):
        Pessoa.__init__(self, nome, idade, endereco, cpf, sexo)
        self.filhos = []
        self.esposa = None

    def addFilho(self, filho):
        self.filhos.append(filho)
        filho.addPai(self)
        print 'Filho adicionado.'

    def addEsposa(self, esposa):
        self.esposa = esposa

    def resumo(self):
        print "========== Resumo do " + self.nome + " ============"
        Pessoa.resumo(self)
        if self.esposa != None:
            print self.esposa.nome + ' é a esposa de ' + self.nome
        print self.nome + ' tem ' + str(len(self.filhos))+ ' filhos'
        print 'Seus filhos se chamam: ' + str([filho.nome for filho in self.filhos])

class Mae(Pessoa):

    def __init__(self, nome, idade, endereco, cpf, sexo):
        Pessoa.__init__(self, nome, idade, endereco, cpf, sexo)
        self.filhos = []
        self.marido = None

    def addFilho(self, filho):
        self.filhos.append(filho)
        filho.addMae(self)
        print 'Filho adicionado.'

    def addMarido(self, marido):
        self.marido = marido

    def resumo(self):
        print "========== Resumo do " + self.nome + " ============"
        Pessoa.resumo(self)
        if self.marido != None:
            print self.marido.nome + ' é o marido de ' + self.nome
        print self.nome + ' tem ' + str(len(self.filhos))+ ' filhos'
        print 'Seus filhos se chamam: ' + str([filho.nome for filho in self.filhos])

class Filho(Pessoa):

    def __init__(self, nome, idade, endereco, cpf, sexo):
        Pessoa.__init__(self, nome, idade, endereco, cpf, sexo)
        self.pai = None
        self.mae = None

    def addPai(self, pai):
        self.pai = pai
        print self.pai.nome + ' agora é pai de ' + self.nome + '.'

    def addMae(self, mae):
        self.mae = mae
        print self.mae.nome + ' agora é mãe de ' + self.nome + '.'

    def resumo(self):
        print "========== Resumo do " + self.nome + " ============"
        Pessoa.resumo(self)
        if self.pai != None:
            print 'Pai: ' + self.pai.nome
        if self.mae != None:
            print 'Mãe: ' + self.mae.nome


pai = Pai('Brunno', 28, 'Fundao', 11232424, 'Masculino')
filho = Filho('Mel', 10, 'Fundao', 2222222, 'Feminino')
pai.addFilho(filho)
mae = Mae('Juliana', 27, 'Fundao', 999999, 'Feminino')
mae.addFilho(filho)
mae.addMarido(pai)
pai.addEsposa(mae)
print
print
print
filho.resumo()
pai.resumo()
mae.resumo()
