# -*- coding: utf-8 -*-

class Pessoa(object):

    def __init__(self, nome, tipo, endereco):
        self.nome = nome
        self.tipo = tipo
        self.endereco = endereco

    def resumo(self):
        print 'Nome: ' + self.nome
        print 'Tipo: ' + self.tipo
        print 'Endereco: ' + self.endereco

class Fisica(Pessoa):

    def __init__(self, nome, cpf, endereco):
        Pessoa.__init__(self, nome, 'fisica', endereco)
        self.nome = 'Pessoa Física'
        self.__cpf = cpf

    @property
    def cpf(self):
        return self.__cpf

    @cpf.setter
    def cpf(self, valor):
        self.__cpf = valor

    def resumo(self):
        Pessoa.resumo(self)
        print 'CPF: ' + self.cpf()


class Juridica(Pessoa):

    def __init__(self, nome, cnpj, endereco):
        Pessoa.__init__(self, nome, 'juridica', endereco)
        self.nome = 'Pessoa Física'
        self.__cnpj = cnpj

    @property
    def cnpj(self):
        return self.__cnpj

    @cnpj.setter
    def cnpj(self, novoValor):
        self.__cnpj = novoValor

    def resumo(self):
        Pessoa.resumo(self)
        print 'CNPJ: ' + self.cnpj()

pessoaFisica = Fisica("Brunno", "123123123", "Fundao")
pessoaJuridica = Juridica("COPPETEC", "00000000", "Fundao")
print pessoaFisica.cpf
print pessoaJuridica.cnpj
pessoaFisica.cpf = "1010101010"
print pessoaFisica.cpf
