#Problema de transposte

#Conjunto de Objetos
set ORIG; #ORIG - Fábricas
set DEST; #DEST - Armazém

#
param oferta {ORIG} >= 0; #quantidade disponível na origem
param demanda {DEST} >= 0; #quantidade requerida no destino


#Verifica se o problema está balanceado
check: sum {i in ORIG} oferta[i] = sum {j in DEST} demanda[j];


param custo {ORIG,DEST} >= 0; #custo de transporte por unidade
var Trans {ORIG,DEST} >= 0; #unidades que serão enviadas da fábrica para o armazém

#Função objetivo
minimize Custo_Total: sum {i in ORIG, j in DEST} custo[i,j] * Trans[i,j];

#Restrições
subject to Oferta {i in ORIG}:
sum {j in DEST} Trans[i,j] = oferta[i];

subject to Demanda {j in DEST}:
sum {i in ORIG} Trans[i,j] = demanda[j];
