
:- module(aggutils,
	   [do_average/3,
	    average/3]).

do_average(Pres,Dom,Val) :-
	add_up(Pres,Dom,0,0,N),
	unmap(N,Dom,Val), !.

add_up([],_,N,Sum,Av) :-
	Av is integer(round(Sum/N)).
add_up([V|Vs],Dom,I0,S0,Av) :-
	clpbn:get_atts(V, [key(K)]),
	user:evidence(K,Val),
	I is I0+1,
	map(Dom,Val,0,N),
	S is S0+N,
	add_up(Vs,Dom,I,S,Av).

average(Pres,Dom,Val) :-
	add_up_values(Pres,Dom,0,0,N),
	unmap(N,Dom,Val), !.

add_up_values([],_,0,0,Av) :- !, fail.
add_up_values([],_,N,Sum,Av) :-
	Av is integer(round(Sum/N)).
add_up_values([Val|Vs],Dom,I0,S0,Av) :-
	I is I0+1,
	map(Dom,Val,0,N),
	S is S0+N,
	add_up_values(Vs,Dom,I,S,Av).

map([X|_], X, N, N) :- !.
map([_|Dom],Val,N0,N) :-
	NI is N0+1,
	map(Dom,Val,NI,N).

unmap(0,[X|_],X) :- !.
unmap(N,[_|Dom],Val) :-
	N1 is N-1,
	unmap(N1,Dom,Val).

