%
%
% calculate the likelihood for an example
% from its execution graph.
%
%

:- module(likelihood, [likelihood/3]).

:- use_module(aggutils, [do_average/3]).

likelihood(Vs,V,Lk) :-
%	attributes:all_attvars(Vs),
	likelihood2(V,Vs,Lk).

likelihood2(V, Vs, Lk) :-
	clpbn:get_atts(V, [key(K),dist(D=>Vals)]),
	likelihood_with(D,Vals,Vs,K,Prob), !,
	Lk is log(Prob).


% likelihood_with((average.Pres),_,average(K),Prob) :- !,
% 	user:domain(K,Dom),
% 	(
% 	  do_average(Pres, Dom, Av)
% 	->
% 	  user:evidence(K,Val),
% 	  (Val = Av -> Prob = 1.0 ; Prob = 0.001)
% 	;
% 	  /* different domains */
% 	  Prob = 0.00001
% 	).
likelihood_with((Dist._),Vals,Vs,K,Prob) :-
	Dist = [_|_], !,
	get_position(Vs,D,Sz0),
	once(user:evidence(K,Ev)),
	find_position(Vals, Ev, 0, Pos, _),
	TruePos is Sz0*Pos+D,
	fetch_prob(TruePos,Dist,Prob).
%	format("Prob at ~d is ~f (key ~w).~n",[TruePos,Prob,K]).
likelihood_with(D,Vals,_,K,Prob) :-
	once(user:evidence(K,Ev)),
	find_prob(Vals,Ev,D,Prob,0,_,_).

get_position([], 0, 1).
get_position([V|Pres], PosF, NSz) :-
	clpbn:get_atts(V,[dist((average.LVars)=>Vals)]), !,
	get_position(Pres, Pos0, Sz0),
	do_average(LVars,Vals,Ev),
	find_position(Vals, Ev, 0, Pos, ValsSz),
	NSz is Sz0*ValsSz,
	PosF is Sz0*Pos+Pos0.
get_position([V|Pres], PosF, NSz) :-
	get_position(Pres, Pos0, Sz0),
	clpbn:get_atts(V,[key(K),dist(_=>Vals)]),
	% vsc: just look at the first instance of evidence.
	once(user:evidence(K,Ev)),
	find_position(Vals, Ev, 0, Pos, ValsSz),
%	format("~w->~w->~w  ",[K,Ev,Pos]),
	NSz is Sz0*ValsSz,
	PosF is Sz0*Pos+Pos0.

find_prob([V|Vals],V,[P|_],P,L0,L0,Lf) :- !,
	L1 is L0+1,
	length(Vals,L1,Lf).
find_prob([_|Vals],V,[_|D],Prob,L0,Li,Lf) :-
	L1 is L0+1,
	find_prob(Vals,V,D,Prob,L1,Li,Lf).

find_position([V|Vals],V,L0,L0,Lf) :- !,
	L1 is L0+1,
	length(Vals,L1,Lf).
find_position([_|Vals],V,L0,Li,Lf) :-
	L1 is L0+1,
	find_position(Vals,V,L1,Li,Lf).

length([],L,L).
length([_|Vals],L0,Lf) :-
	L1 is L0+1,
	length(Vals,L1,Lf).

fetch_prob(0,[Prob|_],Prob) :- !.
fetch_prob(Pos,[_|D],Prob) :-
	Pos1 is Pos-1,
	fetch_prob(Pos1,D,Prob).


	
