%
% New weight calculation function, much simpler than previous.
%
%

:- module(weights, [init_weights/1,
		    add_weights/1,
		    calculate_weights/2,
		    calculate_weights_with_likelihood/4]).

init_weights(D) :-
	catch(close_static_array(w),error(_,_),fail),
	fail.
init_weights(D) :-
	table_size(D,1,Sz),
	static_array(w,Sz,int).

table_size([],Sz,Sz).
table_size([d(D,_)|Ds],Sz0,Szf) :-
	length(D,LD),
	Szi is Sz0*LD,
	table_size(Ds,Szi,Szf).

add_weights(Ds) :-
	evidences_from(Ds, 0, Pos, 1, _),
%	format("at ~d .~n",[Pos]),
%	format("asserted w(~d,~d).~n",[Pos,Sz]),
	add_to_array_element(w,Pos,1,_).

evidences_from([], Pos, Pos, Sz, Sz).
evidences_from([d(D,V)|Ds], Pos0, Posf, Sz0, Szf) :-
	find_position(D,V,0,P,L),
	PosI is Sz0*P+Pos0,
	SzI is Sz0*L,
	evidences_from(Ds, PosI, Posf, SzI, Szf).

find_position([V|Vals],V,L0,L0,Lf) :- !,
	length([V|Vals],L0,Lf).
find_position([_|Vals],V,L0,P,Lf) :-
	L1 is L0+1,
	find_position(Vals,V,L1,P,Lf).

length([], I, I).
length([_|L], I0, If) :-
	I is I0+1,
	length(L, I, If).

calculate_weights(Table, Dom) :-
	static_array_to_term(w,T),
%	format("[ weight matrix: ~w ]~n", [T]),
	functor(T,w,Ar),
	length(Dom,DL),
	Cols is Ar//DL,
	col_sums(0,Cols,Ar,T,ColSums),
	Norm =.. [n|ColSums],
	normalise(0,Ar,T,Norm,Cols,Table),
	close_static_array(w).
	
calculate_weights_with_likelihood(Table, Dom, Likelihood, NEls) :-
	static_array_to_term(w,T),
%	format("[ weight matrix: ~w ]~n", [T]),
	functor(T,w,Ar),
	length(Dom,DL),
	Cols is Ar//DL,
	col_sums(0,Cols,Ar,T,ColSums),
	Norm =.. [n|ColSums],
	normalise(0,Ar,T,Norm,Cols,Table),
	close_static_array(w),
	calculate_likelihood(0,Ar,T,Table,0,Likelihood,0,NEls).
	
col_sums(Cols,Cols,_,_,[]) :- !.
col_sums(I0,Cols,Ar,T,[ColSum|ColSums]) :-
	I is I0+1,
	add_col(I,Ar,T,Cols,0,ColSum),
	col_sums(I,Cols,Ar,T,ColSums).

add_col(I,Ar,_,_,ColSum,ColSum) :- I > Ar, !.
add_col(I,Ar,T,Cols,ColSum0,ColSum) :-
	arg(I,T,El),
	ColSum1 is El+ColSum0,
	NI is I+Cols,
	add_col(NI,Ar,T,Cols,ColSum1,ColSum).

normalise(Ar,Ar,_,_,_,[]) :- !.
normalise(I0,Ar,T,Norm,Cols,[NEl|Table]) :-
	I is I0+1,
	arg(I,T,El),
	IF is (I0 mod Cols)+1,
	arg(IF,Norm,N),
	NEl is El/N,
	normalise(I,Ar,T,Norm,Cols,Table).

calculate_likelihood(Ar,Ar,_,[],Likelihood,Likelihood,N,N) :- !.
calculate_likelihood(I0,Ar,T,[P|Table],Likelihood0,Likelihood,N0,NF) :-
	I is I0+1,
	arg(I,T,A),
	add_to_likelihood(A,P,Likelihood0,LikelihoodI),
	NI is N0+A,
	calculate_likelihood(I,Ar,T,Table,LikelihoodI,Likelihood,NI,NF).

add_to_likelihood(0,_,Likelihood,Likelihood) :- !.
add_to_likelihood(A,P,Likelihood0,Likelihood) :-
	Likelihood is A*log(P)+Likelihood0.


