%
% CLP(BN) CPT manipulation routines.
%


:- module(predictor,[
		     match/4,
		     output_distribution/4,
		     transform_to_predictor/3]).

% :- use_module(user, [evidence/2,domain/2]).

%
% transform_to_predictor generates a predictor out of a CLPBN clause.
%
%
transform_to_predictor(B,NB,V) :- 
	transform_to_predictor(B,NB,V,L,L). 


transform_to_predictor((true,B),NB,V,[],L) :- !,
	transform_to_predictor(B,NB,V,[],L).
transform_to_predictor((A,B),(evidence(K,El),NB),V,[El-Dom|NL],L) :-
	A =.. [Na,Key,El],
	K =.. [Na,Key],
	\+ \+ user:evidence(K,_), !,
	user:domain(K,Dom),
	transform_to_predictor(B,NB,V,NL,L).
transform_to_predictor((A,B),(A,NB),V,NL,L) :-
	transform_to_predictor(B,NB,V,NL,L).
transform_to_predictor((V = {_: (TAB=>DOM)}),
		       (set_value(clpbn_match,u),
			   predictor:output_distribution(LD,NT,DOM,Probs),
			   predictor:make_up_your_mind(Probs,DOM,V)),
		       V,[],L) :-
	fetch_table(TAB,T,Vs),
        % make sure the two domains follow the original variable order.
	match_domains(Vs,L,LD),
	NT =.. [tab|T].

fetch_table([[T1|RT]|LV], [T1|RT], LV) :- !.
fetch_table(T, T, []).

match_domains([], [], []).
match_domains([V|Vs], LVs, [V-D|NVs]) :-
	fetch_var(LVs, V, D, NLVs),
	match_domains(Vs, NLVs, NVs).

fetch_var([V1-D|LVs], V, D, LVs) :- V1 == V, !.
fetch_var([Rec|V], LVs,D, [Rec|NLVs]) :-
	fetch_var(V, LVs, D, NLVs).

%
% given a list of input variables with their domains, a CPT table,
% and an output domain, return a value in the domain
% generated randomly and according to the cpt. 
%
match(Dom,Table,ODom,Val) :-
	calc_pos(Dom, 0, 1, I, Max0),
	I1 is I+1,
	length(ODom,L),
	Max is Max0*L,
	fetch_probs(Table, I1, Max0, Max, Probs),
	X is random,
	get_val(Probs,0.0,X,ODom,Val).

%
% given a list of input variables with their domains, a CPT table,
% and an output domain, return the probabilities for the possible output.
%
output_distribution(Dom,Table,ODom,Probs) :-
	calc_pos(Dom, 0, 1, I, Max0),
	I1 is I+1,
	length(ODom,L),
	Max is Max0*L,
	fetch_probs(Table, I1, Max0, Max, Probs).

calc_pos([],I,Sz,I,Sz).
calc_pos([V-Dom|Vs],I0,Sz0,IF,Sz) :- !,
	find_in_dom(Dom,V,0,F,DSz),
	NI is Sz0*F+I0,
	SzI is Sz0*DSz,
	calc_pos(Vs,NI,SzI,IF,Sz).

find_in_dom([V|L],V,I,I,Sz) :- !,
	dom_sz(L,I,Sz).
find_in_dom([_|L],V,I0,I,Sz) :-
	I1 is I0+1,
	find_in_dom(L,V,I1,I,Sz).

dom_sz([],I,IF) :-
	IF is I+1.
dom_sz([_|L],I0,I) :-
	I1 is I0+1,
	dom_sz(L,I1,I).


fetch_probs(_, I, _, Max, []) :-
	I > Max, !.
fetch_probs(Tab, I, Step, Max, [P|Ps]) :-
	arg(I,Tab,P),
	NI is I+Step,
	fetch_probs(Tab, NI, Step, Max, Ps).

get_val([P|_],P0,X,[D|_],D) :-
	P0 =< X, P0+P > X, !.
get_val([P|Ps],P0,X,[_|Ds],V) :-
	NP0 is P0+P,
	get_val(Ps,NP0,X,Ds,V).

make_up_your_mind([P1,_],[D1,_],D1) :-
	user:pthreshold(P0),
	P1 >= P0, !.
make_up_your_mind([_,P2],[_,D2],D2) :-
	user:nthreshold(P0),
	P2 >= P0.

%pthreshold(0.3).
%nthreshold(0.9).


