%
%
%
%

:- module(weights, [add_weights/1,
		    calculate_weights/3]).

:- use_module(aggutils,
	      [do_average/3]).

:- attribute add_weights/2.

add_weights(Vs) :-
	evidences_from(Vs, Pos, Sz),
%	format("asserted w(~d,~d).~n",[Pos,Sz]),
	assertz_static(w(Pos,Sz)).

evidences_from([], 0, 1).
evidences_from([Iv|Ivs], Pos, Sz) :-
	clpbn:get_atts(Iv, [key(K)]),
	user:evidence(K,Ev), !,
	user:domain(K,D),
	find_position(D, Ev, 0, WI, L),
	evidences_from(Ivs, Pos0, Sz0),
%	format("~w->~w->~w ",[K,Ev,WI]),
	Pos is Pos0+Sz0*WI,
	Sz is Sz0*L.
% no evidence, find if a deterministic function of someone else.
evidences_from([Iv|Ivs], Pos, Sz) :-
	clpbn:get_atts(Iv, [dist((average.LVars)=>D)]),
	do_average(LVars,D,Avg),
	find_position(D, Avg, 0, WI, L),
	evidences_from(Ivs, Pos0, Sz0),
%	format("~w->~w ",[Avg,Pos0]),
	Pos is Pos0+Sz0*WI,
	Sz is Sz0*L.

find_position([V|Vals],V,L0,L0,Lf) :- !,
	length([V|Vals],L0,Lf).
find_position([_|Vals],V,L0,P,Lf) :-
	L1 is L0+1,
	find_position(Vals,V,L1,P,Lf).

length([], I, I).
length([_|L], I0, If) :-
	I is I0+1,
	length(L, I, If).

calculate_weights(K,Table, Dom) :-
	user:domain(K,Dom),
	length(Dom,DL),
	once(w(_,Sz)),
	weights(DL,LWeights),
	findall(P,w(P,_),Cases),
	msort(Cases,Listed),
	init_table(Sz,Table),
	build_table(Table, LWeights, Listed, 0),
	abolish(w/2).
	
init_table(0,[]) :- !.
init_table(I0,[_|Table]) :-
	I is I0-1,
	init_table(I,Table).

build_table([], [], [], _).
build_table([Qt|Table], [W|Ws], Listed, I) :-
	fetch_is(Listed, I, 0, N, NListed),
	I1 is I+1,
	(W = 0 -> Qt = 0 ; Qt is N/W),
	build_table(Table, Ws, NListed, I1).

fetch_is([], _, N, N, []) :- !.
fetch_is([I|Listed], I, N0, NF, NListed) :- !,
	N is N0+1,
	fetch_is(Listed, I, N, NF, NListed).
fetch_is(Listed, _, N, N, Listed).



weights(DomL,Table) :-
	once(w(_,Sz0)),
	Sz is Sz0//DomL,
	findall(W,(w(W0,_),W is W0 mod Sz),Ws0),
	msort(Ws0, Ws),
	Sz is Sz0//DomL,
	init_table(Sz,Table0),
	build_table_noweights(Table0, Ws, 0),
	unfold_table(DomL,Table0,Table).


build_table_noweights([], [], _).
build_table_noweights([N|Table], Listed, I) :-
	fetch_is(Listed, I, 0, N, NListed),
	I1 is I+1,
	build_table_noweights(Table, NListed, I1).

unfold_table(0, _, []) :- !.
unfold_table(I,Weights,Table) :-
	I1 is I-1,
	copy_weights(Weights,Table,Table0),
	unfold_table(I1,Weights,Table0).

copy_weights([],L,L).
copy_weights([W|Ws],[W|L],L0) :-
	copy_weights(Ws,L,L0).

